/*
 * Decompiled with CFR 0.152.
 */
package questsadditions.utils;

import com.google.common.collect.Maps;
import com.mojang.datafixers.DataFixer;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.IdMapper;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.util.datafix.DataFixers;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class StructureLoader {
    private static final Map<String, List<StructureTemplate.StructureBlockInfo>> structureRepository = Maps.newHashMap();

    @Nullable
    public static List<StructureTemplate.StructureBlockInfo> get(String name) {
        return structureRepository.computeIfAbsent(name, key -> {
            try {
                return StructureLoader.loadStructure(key);
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        });
    }

    private static List<StructureTemplate.StructureBlockInfo> loadStructure(String name) throws IOException {
        if (name.contains("..")) {
            throw new IOException();
        }
        CompoundTag CompoundTag2 = NbtIo.m_128937_((File)new File("quests_structures/" + name + ".nbt"));
        if (!CompoundTag2.m_128425_("DataVersion", 99)) {
            CompoundTag2.m_128405_("DataVersion", 500);
        }
        CompoundTag nbt = NbtUtils.m_129213_((DataFixer)DataFixers.m_14512_(), (DataFixTypes)DataFixTypes.STRUCTURE, (CompoundTag)CompoundTag2, (int)CompoundTag2.m_128451_("DataVersion"));
        return StructureLoader.loadPalette(nbt.m_128437_("palette", 10), nbt.m_128437_("blocks", 10), -nbt.m_128437_("size", 3).m_128763_(0) / 2);
    }

    public static Rotation getRotation(Direction dir) {
        if (dir == Direction.NORTH) {
            return Rotation.CLOCKWISE_180;
        }
        if (dir == Direction.WEST) {
            return Rotation.CLOCKWISE_90;
        }
        if (dir == Direction.EAST) {
            return Rotation.COUNTERCLOCKWISE_90;
        }
        return Rotation.NONE;
    }

    public static boolean isValidStructure(Level world, BlockPos base, Rotation rot, List<StructureTemplate.StructureBlockInfo> template) {
        for (StructureTemplate.StructureBlockInfo info : template) {
            BlockState state2;
            BlockPos pos = base.m_141952_((Vec3i)info.f_74675_.m_142082_(0, 0, 1).m_7954_(rot));
            BlockState state = world.m_8055_(pos);
            if (state.equals(state2 = info.f_74676_.m_60717_(rot))) continue;
            return false;
        }
        return true;
    }

    private static List<StructureTemplate.StructureBlockInfo> loadPalette(ListTag palette, ListTag states, int offsetX) {
        BasicPalette template$basicpalette = new BasicPalette();
        for (int i = 0; i < palette.size(); ++i) {
            template$basicpalette.addMapping(NbtUtils.m_129241_((CompoundTag)palette.m_128728_(i)), i);
        }
        ArrayList<StructureTemplate.StructureBlockInfo> blocks = new ArrayList<StructureTemplate.StructureBlockInfo>();
        for (int j = 0; j < states.size(); ++j) {
            CompoundTag CompoundTag2 = states.m_128728_(j);
            ListTag ListTag2 = CompoundTag2.m_128437_("pos", 3);
            BlockPos blockpos = new BlockPos(ListTag2.m_128763_(0) + offsetX, ListTag2.m_128763_(1), ListTag2.m_128763_(2));
            BlockState blockstate = template$basicpalette.stateFor(CompoundTag2.m_128451_("state"));
            CompoundTag CompoundTag1 = null;
            if (CompoundTag2.m_128441_("nbt")) {
                CompoundTag1 = CompoundTag2.m_128469_("nbt");
                CompoundTag1.m_128405_("x", blockpos.m_123341_());
                CompoundTag1.m_128405_("y", blockpos.m_123342_());
                CompoundTag1.m_128405_("z", blockpos.m_123343_());
            }
            StructureTemplate.StructureBlockInfo info2 = new StructureTemplate.StructureBlockInfo(blockpos, blockstate, CompoundTag1);
            blocks.add(info2);
        }
        Comparator<StructureTemplate.StructureBlockInfo> comparator = Comparator.comparingInt(info -> info.f_74675_.m_123342_()).thenComparingInt(info -> info.f_74675_.m_123341_()).thenComparingInt(info -> info.f_74675_.m_123343_());
        blocks.sort(comparator);
        return blocks;
    }

    static class BasicPalette
    implements Iterable<BlockState> {
        public static final BlockState DEFAULT_BLOCK_STATE = Blocks.f_50016_.m_49966_();
        private final IdMapper<BlockState> ids = new IdMapper(16);

        private BasicPalette() {
        }

        @Nullable
        public BlockState stateFor(int id) {
            BlockState blockstate = (BlockState)this.ids.m_7942_(id);
            return blockstate == null ? DEFAULT_BLOCK_STATE : blockstate;
        }

        @Override
        public Iterator<BlockState> iterator() {
            return this.ids.iterator();
        }

        public void addMapping(BlockState state, int id) {
            this.ids.m_122664_((Object)state, id);
        }
    }
}

